/**
  Copyright (c) 2014 Freescale Semiconductor
  
  \file       mc_video.c
  \brief      Video, from VIU
  \author     Freescale Semiconductor
  \author     
  \version    
  
  * History:  

* Copyright (c) 2014, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "..\HIL\Graphics.h"
#include "..\HIL\Display.h"
#include "..\HIL\Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "..\HIL\FontLibrary.h"

#include "tiny_ui.h"
#include "tiny_ui_util_nOS.h"
#include "tiny_ui_platform.h"

#include "math.h"
#include "mc_parameters.h"

#include ".\coverflow\ALBUMS.h"

tiny_ui_buffer_t videoBuf[3];

void mc_video(uint32_t CurrentFrame)
{
    uint32_t relative_fr;
    uint32_t i;
    tiny_ui_error_t error;
    tiny_ui_matrix_t matrix;
    static int toggle = 1;
    
    Graphics_Object_t tmp;
    
    if(mc_video_properties.frameLatch == 0u)
    {
        mc_video_properties.frameLatch = CurrentFrame;
    }
    relative_fr = CurrentFrame - mc_video_properties.frameLatch;
    switch(relative_fr)
    {    
      case 0:
      break;
      case 1: 
	  
        //TODO: reserve the three buffers for your memory here
		//TODO: you may need more memory, we will need to modify the header file
		//TODO: we need to move everything to Flash, before you can use the 2.3MB available
		//TODO: for the moment, you can use smaller buffers, the VIU can downscale
		//TODO: three buffers are required: 1) write buffer, the buffer which the VIU is currently writing
		//TODO: 2) Show buffer, the buffer is currently being shown, should not be written
		//TODO: 3) Ready buffer, the buffer which will be used next by the VIU. 
		
        for(i = 0; i < 3; ++i)
        {
          videoBuf[i].width	= 400;
          videoBuf[i].height	= 272;
          videoBuf[i].stride	= videoBuf[i].width*2;
          videoBuf[i].format	= TINY_UI_RGBA4444;//TINY_UI_RGB565;
          error = tiny_ui_allocate(&videoBuf[i]);
          if (error) while(1);
        }
		
		//TODO: show here the video, I am using another image... you will use videoBuf
		//Display_InitLayer(VIDEO_MAIN,ALBUMS_GObjectArray[0],220, 155);
        
      break;
        
      default:
		//TODO: here you do the synching of the VIU buffers and the Display_InitLayer, selecting the ready buffer.
		//TODO: Each time VIU is finished and starts with another buffer, the 1) becomes 2), 2) becomes 3) and 3) becomes 1) 
		//TODO: you will need to draw stuff into the buffer, as soon as the VIU is done, and then when ready, show it.
		//Display_InitLayer(VIDEO_MAIN,ALBUMS_GObjectArray[0],220, 155);
      break;
    }
    
}

void mc_video_Dispose()
{
	//TODO: use tiny_ui_free to free all the buffers you allocated
	for(int i =0; i<3; i++)
	{
	tiny_ui_free(&videoBuf[i]);
	}
	//TODO: deallocated the used layers
	DCU_LayerDisable(VIDEO_MAIN);	
}

void mc_video_Refresh()
{

}
